/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.filter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.quest.filter.EntityFilterType;
import dev.toma.gunsrpg.common.quests.quest.filter.IEntityFilter;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SpecificEntityFilter
implements IEntityFilter {
    private final EntityType<?>[] types;

    public SpecificEntityFilter(EntityType<?>[] types) {
        this.types = types;
    }

    @Override
    public EntityFilterType<?> getType() {
        return EntityFilterType.SPECIFIC;
    }

    @Override
    public boolean test(Entity entity) {
        return ModUtils.contains(entity.func_200600_R(), this.types);
    }

    public String toString() {
        return String.format("[%s]", String.join((CharSequence)",", (CharSequence[])Arrays.stream(this.types).map(type -> type.getRegistryName().toString()).toArray(String[]::new)));
    }

    public static final class Serializer
    implements EntityFilterType.Serializer<SpecificEntityFilter> {
        @Override
        public SpecificEntityFilter resolveFile(EntityFilterType<SpecificEntityFilter> type, JsonElement json) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(json);
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"filter");
            EntityType[] types = JsonHelper.deserializeInto(array, EntityType[]::new, el -> {
                ResourceLocation resource = new ResourceLocation(el.getAsString());
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(resource);
                if (entityType == null) {
                    GunsRPG.log.warn(QuestSystem.MARKER, "Skipping unknown entity filter: {}", (Object)resource);
                    return null;
                }
                return entityType;
            });
            EntityType[] validTypes = (EntityType[])Arrays.stream(types).filter(Objects::nonNull).toArray(EntityType[]::new);
            if (validTypes.length == 0) {
                throw new JsonSyntaxException("Invalid entity filter! Atleast one entity must be defined");
            }
            return new SpecificEntityFilter(validTypes);
        }

        @Override
        public void toNbt(SpecificEntityFilter filter, CompoundNBT nbt) {
            ListNBT list = new ListNBT();
            Arrays.stream(filter.types).map(type -> StringNBT.func_229705_a_((String)type.getRegistryName().toString())).forEach(arg_0 -> list.add(arg_0));
            nbt.func_218657_a("filter", (INBT)list);
        }

        @Override
        public SpecificEntityFilter fromNbt(EntityFilterType<SpecificEntityFilter> filterType, CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("filter", 8);
            EntityType[] validTypes = (EntityType[])list.stream().map(inbt -> {
                ResourceLocation resourceLocation = new ResourceLocation(inbt.func_150285_a_());
                return (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
            }).toArray(EntityType[]::new);
            return new SpecificEntityFilter(validTypes);
        }
    }
}

